create or replace package tbicds.PCK_TEMPLATE
AUTHID CURRENT_USER
is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
  --custom to return recordsets
  type RetRefCursor is ref cursor;
  type refCursor is ref cursor;

  procedure InsertTemplate(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           pi_nSOAPsectID      in number,
                           pi_vTemplateName    in varchar2,
                           pi_vTemplateText    in clob,
                           pi_nTempGroupID     in number,
                           po_nTemplateID      out number,
                           po_nStatusCode      out number,
                           po_vStatusComment   out varchar2);

  procedure UpdateTemplate(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           pi_nTemplateID      in number,
                           pi_nGroupID         in number,
                           pi_vTemplateName    in varchar2,
                           pi_vTemplateText    in clob,
                           po_nStatusCode      out number,
                           po_vStatusComment   out varchar2);
                                 
  procedure GetParsedTemplate2RS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 pi_vPatientID       in varchar2,
                                 pi_vEncounterID     in varchar2,
                                 pi_nTemplateID      in number,
                                 pi_vKey             in varchar2,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2,
                                 rs                  out RetRefCursor);

  procedure GetTemplateDataTagRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2,
                                 rs                  out RetRefCursor);

  procedure GetTemplateDataTagGroupRS(pi_vSessionID       in varchar2,
                                      pi_vSessionClientIP in varchar2,
                                      pi_nUserID          in number,
                                      po_nStatusCode      out number,
                                      po_vStatusComment   out varchar2,
                                      rs                  out RetRefCursor);

  procedure GetTemplateTypeRS(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2,
                              rs                  out RetRefCursor);

  procedure GetTemplateRS(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor);
                          
  procedure GetTemplateRS(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_nTypeID          in number,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor);

  procedure DiscontinueTemplate(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_nTemplateID      in number,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2);

  procedure InsertTemplateGroup(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_vTemplateGrpName in varchar2,
                                pi_vComments        in varchar2,
                                po_nTemplateGrpID   out number,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2);

  procedure UpdateTemplateGroup(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_nTemplateGrpID   in number,
                                pi_vTemplateGrpName in varchar2,
                                pi_vComments        in varchar2,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2);

  procedure DiscontinueTemplateGroup(pi_vSessionID       in varchar2,
                                     pi_vSessionClientIP in varchar2,
                                     pi_nUserID          in number,
                                     pi_nTemplateGrpID   in number,
                                     po_nStatusCode      out number,
                                     po_vStatusComment   out varchar2);

  procedure GetTemplateGroupsRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor);

  procedure GetGroupTemplatesRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_nGroupID         in number,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor);

  function fnGetParsedTemplateText(pi_vPatientID    in varchar2,
                                   pi_vKey          in varchar2,
                                   pi_vTemplateText in varchar2) return clob;
                                   
  function fnReplaceClob (pi_source in clob
                         ,pi_search in varchar2
                         ,pi_replace in clob) return clob;                                    

end;
/

